; My very second AVR project - write to the UART on a attiny2313

.include "tn2313def.inc" 
.equ	FREQ = 8000000
.equ	BAUD	=	19200		; Baud rate
.equ	UBR		=	FREQ / (16 * BAUD) - 1

.def	Temp	=r16		;temporary register
.def	Delay	=r17
.def	Delay2	=r18
.def	upper	=r19
.def	char	=r20

;***** Initialization

.ORG 0x0
	rjmp   RESET


RESET:
	ldi	Temp, $18
	out	UCR, Temp
	ldi	char, 32	; start with '0'
	ldi	upper, 123
	ldi	TEMP, UBR
	out UBRR, Temp

LOOP1:	
	out	UDR, char	; output char to UART Data Reg
	inc	char		; next char

; just a simple delay loop
DLY:
	dec	Delay
	dec	Delay
	inc	Delay
	brne	DLY
	dec	Delay2
	brne	DLY

	cp	upper, char
	brne	LOOP1
	ldi	char, 32
	rjmp	LOOP1

